# SHC App - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SHC App**

## CapabilityStatement: SHC App 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/CapabilityStatement/SHCAppCapabilityStatement | *Version*:0.3.0-draft |
| Draft as of 2025-04-16 | *Computable Name*:SHCApp |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This CapabilityStatement describes the capabilities of the SHC App. These capabilities include supported FHIR profiles, RESTful operations, and search parameters. It covers supported tasks such as SMART App launch context, prepopulation, write-back of extracted resources and completion of forms. 

 [Raw OpenAPI-Swagger Definition file](SHCAppCapabilityStatement.openapi.json) | [Download](SHCAppCapabilityStatement.openapi.json) 

## SHC App

* Implementation Guide Version: 0.3.0-draft 
* FHIR Version: 4.0.1 
* Supported Formats: `json`
* Supported Patch Formats: `application/fhir+json`
* Published on: 2025-04-16 
* Published by: AEHRC CSIRO 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

This CapabilityStatement instantiates these CapabilityStatements [SDC Form Filler](http://hl7.org/fhir/uv/sdc/2025Jan/CapabilityStatement-sdc-form-filler.html), [AU Core Requester CapabilityStatement](http://hl7.org.au/fhir/core/2.0.0-ballot/CapabilityStatement-au-core-requester.html)

### SHALL Support the Following Implementation Guides

* [http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch|2.2.0](http://hl7.org/fhir/smart-app-launch/STU2.2/index.html)

## FHIR RESTful Capabilities

### Mode: client

The SHC App performs interactions to support SMART App Launch, form prepopulation, write-back of extracted resources and form filling.

**Security**

Enable CORS: yes

Security services supported:
`SMART-on-FHIR`

> 

SMART App Launch supported to allow secure data exchange.


**Summary of System-wide Interactions**

* Supports the `transaction`interaction.
* Supports the `batch`interaction.

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AllergyIntolerance](#AllergyIntolerance1-1) | Supported Profiles  [Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md) |  | y |  | y | y | patient |  |  |  |
| [Bundle](#Bundle1-2) | Supported Profiles  [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md) |  |  |  |  |  |  |  |  |  |
| [Condition](#Condition1-3) | Supported Profiles  [Smart Health Checks Condition](StructureDefinition-SHCCondition.md) |  | y |  | y | y | patient, category |  |  |  |
| [Encounter](#Encounter1-4) | Supported Profiles  [Smart Health Checks Encounter](StructureDefinition-SHCEncounter.md) | y |  |  |  |  |  |  |  |  |
| [Immunization](#Immunization1-5) | Supported Profiles  [Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md) |  | y |  |  | y | patient, status |  |  |  |
| [Medication](#Medication1-6) | Supported Profiles  [Smart Health Checks Medication](StructureDefinition-SHCMedication.md) | y |  |  |  |  |  |  |  |  |
| [MedicationStatement](#MedicationStatement1-7) | Supported Profiles  [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md) |  | y |  | y | y | patient, status, _include | `MedicationStatement:medication` |  |  |
| [Observation](#Observation1-8) | Supported Profiles  [Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md)  [Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md)  [Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md)  [Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md)  [Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md)  [Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md)  [Smart Health Checks Pathology Result](StructureDefinition-SHCPathologyResult.md)  [Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md)  [Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md) |  | y |  |  | y | patient, code, _sort |  |  |  |
| [Parameters](#Parameters1-9) | Supported Profiles  [Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)  [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)  [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md) |  |  |  |  |  |  |  |  |  |
| [Patient](#Patient1-10) | Supported Profiles  [Smart Health Checks Patient](StructureDefinition-SHCPatient.md) | y |  |  |  |  |  |  |  |  |
| [Practitioner](#Practitioner1-11) | Supported Profiles  [Smart Health Checks Practitioner](StructureDefinition-SHCPractitioner.md) | y |  |  |  |  |  |  |  |  |
| [Questionnaire](#Questionnaire1-12) | [http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire](http://hl7.org/fhir/uv/sdc/2025Jan/StructureDefinition-sdc-questionnaire.html) |  | y |  |  | y | url, version, title, _count, _sort |  |  | `$assemble`,`$populate` |
| [QuestionnaireResponse](#QuestionnaireResponse1-13) | [https://smartforms.csiro.au/ig/StructureDefinition/SHCQuestionnaireResponse](StructureDefinition-SHCQuestionnaireResponse.md) | y | y | y |  | y | patient, questionnaire, status, _count, _sort |  |  |  |
| [ValueSet](#ValueSet1-14) |   |  |  |  |  |  |  |  |  | `$expand` |

-------

#### Resource Conformance: supported AllergyIntolerance

Core FHIR Resource

[AllergyIntolerance](http://hl7.org/fhir/R4/allergyintolerance.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`, `patch`.

Supported Profiles
[Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md)

Documentation
> 

The client supports the AllergyIntolerance resource, the Smart Health Checks profile and the conformance expectations for the AllergyIntolerance resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/allergyintolerance.html#search) | `reference` |

#### Resource Conformance: supported Bundle

Core FHIR Resource

[Bundle](http://hl7.org/fhir/R4/bundle.html)

Reference Policy

Interaction summary

Supported Profiles
[Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)

Documentation
> 

The client supports the Bundle resource, the Smart Health Checks profile listed and the conformance expectations for the Bundle resource.


#### Resource Conformance: supported Condition

Core FHIR Resource

[Condition](http://hl7.org/fhir/R4/condition.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`, `patch`.

Supported Profiles
[Smart Health Checks Condition](StructureDefinition-SHCCondition.md)

Documentation
> 

The client supports the Condition resource, the Smart Health Checks and the conformance expectations for the Condition resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/condition.html#search)+[category](http://hl7.org/fhir/R4/condition.html#search) | `reference`+`token` |

#### Resource Conformance: supported Encounter

Core FHIR Resource

[Encounter](http://hl7.org/fhir/R4/encounter.html)

Reference Policy

Interaction summary

* Supports `read`.

Supported Profiles
[Smart Health Checks Encounter](StructureDefinition-SHCEncounter.md)

Documentation
> 

The client supports the Encounter resource, the Smart Health Checks profile and the conformance expectations for the Encounter resource.


#### Resource Conformance: supported Immunization

Core FHIR Resource

[Immunization](http://hl7.org/fhir/R4/immunization.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`.

Supported Profiles
[Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md)

Documentation
> 

The client supports the Immunization resource, the Smart Health Checks profile and the conformance expectations for the Immunization resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/immunization.html#search)+[status](http://hl7.org/fhir/R4/immunization.html#search) | `reference`+`token` |

#### Resource Conformance: supported Medication

Core FHIR Resource

[Medication](http://hl7.org/fhir/R4/medication.html)

Reference Policy

Interaction summary

* Supports `read`.

Supported Profiles
[Smart Health Checks Medication](StructureDefinition-SHCMedication.md)

Documentation
> 

The client supports the Medication resource, the Smart Health Checks profile and the conformance expectations for the Medication resource.


#### Resource Conformance: supported MedicationStatement

Core FHIR Resource

[MedicationStatement](http://hl7.org/fhir/R4/medicationstatement.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`, `patch`.

Supported Profiles
[Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md)

Documentation
> 

The client supports the MedicationStatement resource, the Smart Health Checks profile and the conformance expectations for the MedicationStatement resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/medicationstatement.html#search)+[status](http://hl7.org/fhir/R4/medicationstatement.html#search) | `reference`+`token` |
|   | [patient](http://hl7.org/fhir/R4/medicationstatement.html#search)+[status](http://hl7.org/fhir/R4/medicationstatement.html#search)+_include | `reference`+`token`+`reference` |

#### Resource Conformance: SHALL Observation

Core FHIR Resource

[Observation](http://hl7.org/fhir/R4/observation.html)

Reference Policy

Interaction summary

* Supports `search-type`, `create`.

Supported Profiles
[Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md)
[Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md)
[Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md)
[Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md)
[Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md)
[Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md)
[Smart Health Checks Pathology Result](StructureDefinition-SHCPathologyResult.md)
[Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md)
[Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md)

Documentation
> 

The client supports the Observation resource, the Smart Health Checks profiles listed and the conformance expectations for the Observation resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/observation.html#search)+[code](http://hl7.org/fhir/R4/observation.html#search)+_sort | `reference`+`token`+`string` |

#### Resource Conformance: supported Parameters

Core FHIR Resource

[Parameters](http://hl7.org/fhir/R4/parameters.html)

Reference Policy

Interaction summary

Supported Profiles
[Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)
[Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)
[Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

Documentation
> 

The client supports the Parameters resource, the Smart Health Checks profiles listed and the conformance expectations for the Parameters resource.


#### Resource Conformance: supported Patient

Core FHIR Resource

[Patient](http://hl7.org/fhir/R4/patient.html)

Reference Policy

Interaction summary

* Supports `read`.

Supported Profiles
[Smart Health Checks Patient](StructureDefinition-SHCPatient.md)

Documentation
> 

The client supports the Patient resource, Smart Health Checks profile and the conformance expectations for the Patient resource.


#### Resource Conformance: supported Practitioner

Core FHIR Resource

[Practitioner](http://hl7.org/fhir/R4/practitioner.html)

Reference Policy

Interaction summary

* Supports `read`.

Supported Profiles
[Smart Health Checks Practitioner](StructureDefinition-SHCPractitioner.md)

Documentation
> 

The client supports the Practitioner resource, Smart Health Checks profile and the conformance expectations for the Practitioner resource.


#### Resource Conformance: supported Questionnaire

Base System Profile

[SDC Base Questionnaire](http://hl7.org/fhir/uv/sdc/2025Jan/StructureDefinition-sdc-questionnaire.html)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `search-type`, `create`.

Documentation
> 

The client supports the Questionnaire resource, Structured Data Capture profile and the conformance expectations for the Questionnaire resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [url](http://hl7.org/fhir/R4/questionnaire.html#search)+[version](http://hl7.org/fhir/R4/questionnaire.html#search) | `uri`+`token` |
|   | _count+_sort | `number`+`string` |
|   | [title](http://hl7.org/fhir/R4/questionnaire.html#search)+_count+_sort | `string`+`number`+`string` |

Extended Operations


#### Resource Conformance: supported QuestionnaireResponse

Base System Profile

[Smart Health Checks Questionnaire Response](StructureDefinition-SHCQuestionnaireResponse.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `search-type`, `create`, `update`.

Documentation
> 

The client supports the QuestionnaireResponse resource, Smart Health Checks profile and the conformance expectations for the QuestionnaireResponse resource.


Search Parameters


Combined Search Parameters

| | | |
| :--- | :--- | :--- |
|   | [patient](http://hl7.org/fhir/R4/questionnaireresponse.html#search)+_count+_sort | `reference`+`number`+`string` |
|   | [patient](http://hl7.org/fhir/R4/questionnaireresponse.html#search)+_count+_sort+[questionnaire](http://hl7.org/fhir/R4/questionnaireresponse.html#search) | `reference`+`number`+`string`+`reference` |
|   | [patient](http://hl7.org/fhir/R4/questionnaireresponse.html#search)+_count+_sort+[status](http://hl7.org/fhir/R4/questionnaireresponse.html#search) | `reference`+`number`+`string`+`token` |

#### Resource Conformance: supported ValueSet

Core FHIR Resource

[ValueSet](http://hl7.org/fhir/R4/valueset.html)

Reference Policy

Interaction summary

Documentation
> 

The client supports the ValueSet resource and the conformance expectations for the ValueSet resource.


Extended Operations




## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "SHCAppCapabilityStatement",
  "url" : "https://smartforms.csiro.au/ig/CapabilityStatement/SHCAppCapabilityStatement",
  "version" : "0.3.0-draft",
  "name" : "SHCApp",
  "title" : "SHC App",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-04-16",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This CapabilityStatement describes the capabilities of the SHC App. These capabilities include supported FHIR profiles, RESTful operations, and search parameters. It covers supported tasks such as SMART App launch context, prepopulation, write-back of extracted resources and completion of forms.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "kind" : "capability",
  "instantiates" : [
    "http://hl7.org/fhir/uv/sdc/CapabilityStatement/sdc-form-filler",
    "http://hl7.org.au/fhir/core/CapabilityStatement/au-core-requester"
  ],
  "software" : {
    "name" : "Smart Health Checks Application"
  },
  "fhirVersion" : "4.0.1",
  "format" : ["json"],
  "patchFormat" : ["application/fhir+json"],
  "implementationGuide" : [
    "http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch|2.2.0"
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "The SHC App performs interactions to support SMART App Launch, form prepopulation, write-back of extracted resources and form filling.",
      "security" : {
        "cors" : true,
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "SMART-on-FHIR"
              }
            ]
          }
        ],
        "description" : "SMART App Launch supported to allow secure data exchange."
      },
      "resource" : [
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "AllergyIntolerance",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCAllergyIntolerance"
          ],
          "documentation" : "The client supports the AllergyIntolerance resource, the Smart Health Checks profile and the conformance expectations for the AllergyIntolerance resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            },
            {
              "code" : "patch"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "type" : "Bundle",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCExtractBundle"
          ],
          "documentation" : "The client supports the Bundle resource, the Smart Health Checks profile listed and the conformance expectations for the Bundle resource."
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "category"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Condition",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCCondition"
          ],
          "documentation" : "The client supports the Condition resource, the Smart Health Checks and the conformance expectations for the Condition resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            },
            {
              "code" : "patch"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Condition-category",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values. \r\n\r\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "type" : "Encounter",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCEncounter"
          ],
          "documentation" : "The client supports the Encounter resource, the Smart Health Checks profile and the conformance expectations for the Encounter resource.",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Immunization",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCImmunization"
          ],
          "documentation" : "The client supports the Immunization resource, the Smart Health Checks profile and the conformance expectations for the Immunization resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/Immunization-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values. \r\n\r\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "type" : "Medication",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedication"
          ],
          "documentation" : "The client supports the Medication resource, the Smart Health Checks profile and the conformance expectations for the Medication resource.",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                },
                {
                  "url" : "required",
                  "valueString" : "_include"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "MedicationStatement",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedicationStatement"
          ],
          "documentation" : "The client supports the MedicationStatement resource, the Smart Health Checks profile and the conformance expectations for the MedicationStatement resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            },
            {
              "code" : "patch"
            }
          ],
          "searchInclude" : ["MedicationStatement:medication"],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/medications-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values.\r\n\r\nThe server **SHALL** support both.\r\n\r\nThe client **SHALL** support `multipleOr`.\r\n\r\nThe server **SHALL** support `multipleOr`."
            },
            {
              "name" : "_include",
              "type" : "reference",
              "documentation" : "If a medication in a MedicationStatement resource is represented as an external Medication resource reference, the server **SHALL** support the `_include` parameter for searching this element (`MedicationStatement:medication`).\r\n\r\nThe client **SHALL** support this method."
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "code"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Observation",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBloodPressure",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyHeight",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyWeight",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeadCircumference",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRate",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRhythm",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPathologyResult",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCSmokingStatus",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCWaistCircumference"
          ],
          "documentation" : "The client supports the Observation resource, the Smart Health Checks profiles listed and the conformance expectations for the Observation resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            }
          ],
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both. "
            },
            {
              "name" : "code",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-code",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the code and system values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_sort",
              "type" : "string",
              "documentation" : "The client and server **SHALL** support search result sorting by date and **MAY** support other values."
            }
          ]
        },
        {
          "type" : "Parameters",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchCondition",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          ],
          "_supportedProfile" : [
            null,
            null,
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The client supports the Parameters resource, the Smart Health Checks profiles listed and the conformance expectations for the Parameters resource."
        },
        {
          "type" : "Patient",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatient"
          ],
          "documentation" : "The client supports the Patient resource, Smart Health Checks profile and the conformance expectations for the Patient resource.",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPractitioner"
          ],
          "documentation" : "The client supports the Practitioner resource, Smart Health Checks profile and the conformance expectations for the Practitioner resource.",
          "interaction" : [
            {
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "url"
                },
                {
                  "url" : "required",
                  "valueString" : "version"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "title"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Questionnaire",
          "profile" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire",
          "documentation" : "The client supports the Questionnaire resource, Structured Data Capture profile and the conformance expectations for the Questionnaire resource.",
          "interaction" : [
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            }
          ],
          "searchParam" : [
            {
              "name" : "url",
              "definition" : "http://hl7.org/fhir/SearchParameter/Questionnaire-url",
              "type" : "uri"
            },
            {
              "name" : "version",
              "definition" : "http://hl7.org/fhir/SearchParameter/Questionnaire-version",
              "type" : "token"
            },
            {
              "name" : "title",
              "definition" : "http://hl7.org/fhir/SearchParameter/Questionnaire-title",
              "type" : "string",
              "documentation" : "The client supports search using the :contains modifier."
            },
            {
              "name" : "_count",
              "type" : "number",
              "documentation" : "The client supports search result limiting."
            },
            {
              "name" : "_sort",
              "type" : "string",
              "documentation" : "The client supports search result sorting by date and **MAY** support other values."
            }
          ],
          "operation" : [
            {
              "name" : "assemble",
              "definition" : "http://hl7.org/fhir/uv/sdc/OperationDefinition/Questionnaire-assemble"
            },
            {
              "name" : "populate",
              "definition" : "http://hl7.org/fhir/uv/sdc/OperationDefinition/Questionnaire-populate"
            }
          ]
        },
        {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                },
                {
                  "url" : "required",
                  "valueString" : "questionnaire"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "QuestionnaireResponse",
          "profile" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCQuestionnaireResponse",
          "documentation" : "The client supports the QuestionnaireResponse resource, Smart Health Checks profile and the conformance expectations for the QuestionnaireResponse resource.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            },
            {
              "code" : "create"
            },
            {
              "code" : "update"
            }
          ],
          "versioning" : "versioned-update",
          "searchParam" : [
            {
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both. "
            },
            {
              "name" : "questionnaire",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-questionnaire",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both.\r\n\r\nThe client and server **SHALL** support chained search questionnaire.title using the :contains modifier."
            },
            {
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the code and system values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "name" : "_count",
              "type" : "number",
              "documentation" : "The client and server **SHALL** support search result limiting."
            },
            {
              "name" : "_sort",
              "type" : "string",
              "documentation" : "The client and server **SHALL** support search result sorting by authored and **MAY** support other values."
            }
          ]
        },
        {
          "type" : "ValueSet",
          "documentation" : "The client supports the ValueSet resource and the conformance expectations for the ValueSet resource.",
          "operation" : [
            {
              "name" : "expand",
              "definition" : "http://hl7.org/fhir/OperationDefinition/ValueSet-expand"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "code" : "transaction"
        },
        {
          "code" : "batch"
        }
      ]
    }
  ]
}

```
