# pat-sf - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **pat-sf**

## Example Patient: pat-sf

Profile: [Smart Health Checks Patient](StructureDefinition-SHCPatient.md)

Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))

-------

| | |
| :--- | :--- |
| Other Id: | IHI/8003608833357361 |
| Alt. Name: | Mrs. Smart Form(Official) |
| Contact Detail | * ph: 0491 572 665(Mobile)
* ph: 0123456879(Home)
* 4 Brisbane Street Brisbane QLD 4112 AU (home)
* PO Box Number Brisbane QLD 4112 AU (temp)
 |
| Language: | Yugambal |
| Emergency Contact: | * Ms Phone A Friend
* ph: 0987654321
 |
| Individual Pronouns: | * value: they/them/their/theirs/themselves
* period: 2018-02 --> 2022-06
 |
| Individual Pronouns: | * value: she/her/her/hers/herself
* period: 2022-06 --> (ongoing)
 |
| Person Recorded Sex Or Gender: | * value: Female
* type: Sex at Birth
* effectivePeriod: 2022-06 --> (ongoing)
 |
| Person Recorded Sex Or Gender: | * value: Indeterminate sex
* type: Sex at Birth
* effectivePeriod: 2018-02 --> 2022-06
 |
| [Australian Indigenous Status](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1 1: Aboriginal but not Torres Strait Islander origin |
| Individual Gender Identity: | * value: Identifies as female gender
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "pat-sf",
  "meta" : {
    "profile" : [
      "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
      "valueCoding" : {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
        "code" : "1",
        "display" : "Aboriginal but not Torres Strait Islander origin"
      }
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "446141000124107",
                "display" : "Identifies as female gender"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-genderIdentity"
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "LA29520-6",
                "display" : "they/them/their/theirs/themselves"
              }
            ]
          }
        },
        {
          "url" : "period",
          "valuePeriod" : {
            "start" : "2018-02",
            "end" : "2022-06"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-pronouns"
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "LA29519-8",
                "display" : "she/her/her/hers/herself"
              }
            ]
          }
        },
        {
          "url" : "period",
          "valuePeriod" : {
            "start" : "2022-06"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-pronouns"
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "248152002",
                "display" : "Female"
              }
            ],
            "text" : "Female"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "1515311000168102",
                "display" : "Biological sex at birth"
              }
            ],
            "text" : "Sex at Birth"
          }
        },
        {
          "url" : "effectivePeriod",
          "valuePeriod" : {
            "start" : "2022-06"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender"
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "32570681000036106",
                "display" : "Indeterminate sex"
              }
            ],
            "text" : "Indeterminate sex"
          }
        },
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "1515311000168102",
                "display" : "Biological sex at birth"
              }
            ],
            "text" : "Sex at Birth"
          }
        },
        {
          "url" : "effectivePeriod",
          "valuePeriod" : {
            "start" : "2018-02",
            "end" : "2022-06"
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender"
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MC"
          }
        ],
        "text" : "Medicare Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-number",
      "value" : "69514496771",
      "period" : {
        "end" : "2024-08"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NI",
            "display" : "National unique individual identifier"
          }
        ],
        "text" : "IHI"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/ihi/1.0",
      "value" : "8003608833357361"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "text" : "Mrs. Smart Form",
      "family" : "Form",
      "given" : ["Smart"],
      "prefix" : ["Mrs"]
    },
    {
      "use" : "usual",
      "text" : "Clever Form"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0491 572 665",
      "use" : "mobile"
    },
    {
      "system" : "phone",
      "value" : "0123456879",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "1968-10-11",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "line" : ["4 Brisbane Street"],
      "city" : "Brisbane",
      "state" : "QLD",
      "postalCode" : "4112",
      "country" : "AU"
    },
    {
      "use" : "temp",
      "type" : "postal",
      "line" : ["PO Box Number"],
      "city" : "Brisbane",
      "state" : "QLD",
      "postalCode" : "4112",
      "country" : "AU"
    }
  ],
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "C"
            }
          ]
        }
      ],
      "name" : {
        "use" : "usual",
        "text" : "Ms Phone A Friend"
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "0987654321"
        }
      ]
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "yub"
          }
        ],
        "text" : "Yugambal"
      }
    }
  ]
}

```
