# Contained Resource Reference - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contained Resource Reference**

## Extension: Contained Resource Reference 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference | *Version*:0.3.0-draft |
| Draft as of 2025-10-30 | *Computable Name*:ContainedResourceReference |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

This extension is intended to be used as a work around to a known bug whereby contained resources that are not referenced with the type, 'Reference' are removed before a resource is created in a HAPI FHIR server. This is problematic when referencing with the type, 'canonical'. The extension can be used to reference contained resources so they are retained when added to a HAPI FHIR server.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [AboriginalTorresStraitIslanderHealthCheck](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.md) and [AboriginalTorresStraitIslanderHealthCheck](Questionnaire-AssemblyInstructions.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/ContainedResourceReference)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ContainedResourceReference.csv), [Excel](StructureDefinition-ContainedResourceReference.xlsx), [Schematron](StructureDefinition-ContainedResourceReference.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ContainedResourceReference",
  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference",
  "version" : "0.3.0-draft",
  "name" : "ContainedResourceReference",
  "title" : "Contained Resource Reference",
  "status" : "draft",
  "date" : "2025-10-30T20:31:27+10:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This extension is intended to be used as a work around to a known bug whereby contained resources that are not referenced with the type, 'Reference' are removed before a resource is created in a HAPI FHIR server. This is problematic when referencing with the type, 'canonical'. The extension can be used to reference contained resources so they are retained when added to a HAPI FHIR server.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Contained Resource Reference",
        "definition" : "This extension is intended to be used as a work around to a known bug whereby contained resources that are not referenced with the type, 'Reference' are removed before a resource is created in a HAPI FHIR server. This is problematic when referencing with the type, 'canonical'. The extension can be used to reference contained resources so they are retained when added to a HAPI FHIR server."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://smartforms.csiro.au/ig/StructureDefinition/ContainedResourceReference"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference"
          }
        ]
      }
    ]
  }
}

```
