# Smart Health Checks Immunization - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Immunization**

## Resource Profile: Smart Health Checks Immunization 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCImmunization | *Version*:0.3.0-draft |
| Draft as of 2025-10-30 | *Computable Name*:SmartHealthChecksImmunization |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the minimum expectations for an Immunization resource to record, search and save immunization information when used within Smart Health Checks. 

**Usages:**

* Use this Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCImmunization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SHCImmunization.csv), [Excel](StructureDefinition-SHCImmunization.xlsx), [Schematron](StructureDefinition-SHCImmunization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SHCImmunization",
  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCImmunization",
  "version" : "0.3.0-draft",
  "name" : "SmartHealthChecksImmunization",
  "title" : "Smart Health Checks Immunization",
  "status" : "draft",
  "date" : "2025-10-30T20:31:27+10:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This profile sets the minimum expectations for an Immunization resource to record, search and save immunization information when used within Smart Health Checks.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Immunization",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Immunization.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Immunization.status"
      },
      {
        "id" : "Immunization.vaccineCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Immunization.vaccineCode"
      },
      {
        "id" : "Immunization.vaccineCode.coding:amtVaccineCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Immunization.vaccineCode.coding",
        "sliceName" : "amtVaccineCode"
      },
      {
        "id" : "Immunization.vaccineCode.text",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable",
            "valueBoolean" : true
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Immunization.vaccineCode.text",
        "mustSupport" : true
      },
      {
        "id" : "Immunization.patient",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Immunization.patient"
      },
      {
        "id" : "Immunization.occurrence[x]",
        "path" : "Immunization.occurrence[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.occurrence[x]:occurrenceDateTime",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHOULD:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Immunization.occurrence[x]",
        "sliceName" : "occurrenceDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "extension" : [
                  {
                    "url" : "code",
                    "valueCode" : "SHALL:populate-if-known"
                  },
                  {
                    "url" : "actor",
                    "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
                  },
                  {
                    "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                    "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
                  }
                ],
                "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
              },
              {
                "extension" : [
                  {
                    "url" : "code",
                    "valueCode" : "SHOULD:populate"
                  },
                  {
                    "url" : "actor",
                    "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
                  },
                  {
                    "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                    "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
                  }
                ],
                "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
              },
              {
                "extension" : [
                  {
                    "url" : "code",
                    "valueCode" : "SHALL:no-error"
                  },
                  {
                    "url" : "actor",
                    "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
                  },
                  {
                    "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                    "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
                  }
                ],
                "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Immunization.lotNumber",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Immunization.lotNumber"
      },
      {
        "id" : "Immunization.note.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Immunization.note.text",
        "mustSupport" : true
      }
    ]
  }
}

```
