# Smart Health Checks MedicationStatement - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks MedicationStatement**

## Resource Profile: Smart Health Checks MedicationStatement 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCMedicationStatement | *Version*:0.3.0-draft |
| Draft as of 2025-10-30 | *Computable Name*:SmartHealthChecksMedicationStatement |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the minimum expectations for a MedicationStatement resource to record, search and save medication information when used within Smart Health Checks. 

**Usages:**

* Use this Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)
* Examples for this Profile: [MedicationStatement/active-bisoprolol-pat-sf](MedicationStatement-active-bisoprolol-pat-sf.md) and [MedicationStatement/chloramphenicol-pat-sf](MedicationStatement-chloramphenicol-pat-sf.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCMedicationStatement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SHCMedicationStatement.csv), [Excel](StructureDefinition-SHCMedicationStatement.xlsx), [Schematron](StructureDefinition-SHCMedicationStatement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SHCMedicationStatement",
  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedicationStatement",
  "version" : "0.3.0-draft",
  "name" : "SmartHealthChecksMedicationStatement",
  "title" : "Smart Health Checks MedicationStatement",
  "status" : "draft",
  "date" : "2025-10-30T20:31:27+10:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This profile sets the minimum expectations for a MedicationStatement resource to record, search and save medication information when used within Smart Health Checks.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement.id",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.id",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.status"
      },
      {
        "id" : "MedicationStatement.medication[x]:medicationCodeableConcept",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.medication[x]",
        "sliceName" : "medicationCodeableConcept",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicationStatement.medication[x]:medicationCodeableConcept.text",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable",
            "valueBoolean" : true
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.medication[x].text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.medication[x]:medicationReference",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.medication[x]",
        "sliceName" : "medicationReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedication"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.subject"
      },
      {
        "id" : "MedicationStatement.dateAsserted",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.dateAsserted"
      },
      {
        "id" : "MedicationStatement.reasonCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.reasonCode"
      },
      {
        "id" : "MedicationStatement.note",
        "path" : "MedicationStatement.note",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.note.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.note.text",
        "mustSupport" : true
      },
      {
        "id" : "MedicationStatement.dosage",
        "path" : "MedicationStatement.dosage",
        "max" : "1"
      },
      {
        "id" : "MedicationStatement.dosage.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              },
              {
                "url" : "http://hl7.org/fhir/tools/StructureDefinition/snapshot-source",
                "valueCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement|2.0.0-ballot"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:persist"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "MedicationStatement.dosage.text"
      }
    ]
  }
}

```
