# Smart Health Checks Patch AllergyIntolerance - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Smart Health Checks Patch AllergyIntolerance**

## Resource Profile: Smart Health Checks Patch AllergyIntolerance 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance | *Version*:0.3.0-draft |
| Draft as of 2025-10-30 | *Computable Name*:SmartHealthChecksPatchAllergyIntolerance |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This profile sets the expectations for a Parameters resource when used to patch AllergyIntolerance resources within Smart Health Checks. 

### Usage Scenarios

This profile supports updating AllergyIntolerance resource elements that are applicable to Smart Health Checks using the FHIRPath patch method. FHIRPath patch uses the Parameters resource to describe how a patch operation should be performed.

The elements that can be updated using this profile are as follows:

* Profile: [Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md)
  * Element path: * `AllergyIntolerance.clinicalStatus`
* `AllergyIntolerance.note[0].text`


### Profile Specific Implementation Guidance

* `Parameters.parameter.part:path.value[x]:valueString` **SHALL** identify one of the relevant AllergyIntolerance element paths included in the [Smart Health Checks Patch AllergyIntolerance Element Path value set](ValueSet-SHCPatchAllergyIntoleranceElementPath.md): `AllergyIntolerance` or `AllergyIntolerance.note[0]`.
* `Parameters.parameter.part:name.value[x]:valueString` **SHALL** identify one of the relevant AllergyIntolerance element paths included in the [Smart Health Checks Patch AllergyIntolerance Element Name value set](ValueSet-SHCPatchAllergyIntoleranceElementName.md): `clinicalStatus`, `note` or `text`.
* When the path value is `AllergyIntolerance` and the name value is `clinicalStatus`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `CodeableConcept`
* `Parameters.parameter.part:value.value[x]:valueCodeableConcept` **SHALL** have a value from the [Allergy Intolerance Clinical Status Minimal value set](ValueSet-AllergyIntoleranceClinicalStatusMinimal.md).
 
* When the path value is `AllergyIntolerance` and the name value is `note`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `Annotation`.
 
* When the path value is `AllergyIntolerance.note[0]` and the name value is `text`: 
* `Parameters.parameter.part:value.value[x]` **SHALL** be of type `markdown`.
 

Illustrative examples are provided.

**Usages:**

* Use this Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)
* Examples for this Profile: [Parameters/SHCPatchAllergyIntolerance1](Parameters-SHCPatchAllergyIntolerance1.md) and [Parameters/SHCPatchAllergyIntolerance2](Parameters-SHCPatchAllergyIntolerance2.md)
* CapabilityStatements using this Profile: [SHC App](CapabilityStatement-SHCAppCapabilityStatement.md) and [SHC Host FHIR Server](CapabilityStatement-SHCHostFHIRServerCapabilityStatement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/SHCPatchAllergyIntolerance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SHCPatchAllergyIntolerance.csv), [Excel](StructureDefinition-SHCPatchAllergyIntolerance.xlsx), [Schematron](StructureDefinition-SHCPatchAllergyIntolerance.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SHCPatchAllergyIntolerance",
  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance",
  "version" : "0.3.0-draft",
  "name" : "SmartHealthChecksPatchAllergyIntolerance",
  "title" : "Smart Health Checks Patch AllergyIntolerance",
  "status" : "draft",
  "date" : "2025-10-30T20:31:27+10:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This profile sets the expectations for a Parameters resource when used to patch AllergyIntolerance resources within Smart Health Checks.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Parameters",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Parameters",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Parameters",
        "path" : "Parameters",
        "short" : "Parameters for patching AllergyIntolerance resource elements supported in Smart Health Checks",
        "constraint" : [
          {
            "key" : "shc-patch-allergy-intolerance-01",
            "severity" : "error",
            "human" : "When the part parameter named 'path' has a value of 'AllergyIntolerance' and the part parameter named 'name' has a value of 'clinicalStatus', the part parameter named 'value' SHALL have a value from the 'Allergy Intolerance Clinical Status Minimal' value set.",
            "expression" : "parameter.where(part.where(name='path').value = 'AllergyIntolerance' and part.where(name='name').value = 'clinicalStatus').exists() implies parameter.where(part.where(name='path').value = 'AllergyIntolerance' and part.where(name='name').value = 'clinicalStatus').part.where(name='value').value.memberOf('https://smartforms.csiro.au/ig/ValueSet/AllergyIntoleranceClinicalStatusMinimal')",
            "source" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance"
          },
          {
            "key" : "shc-patch-allergy-intolerance-02",
            "severity" : "error",
            "human" : "When the part parameter named 'path' has a value of 'AllergyIntolerance' and the part parameter named 'name' has a value of 'note', the part parameter named 'value' SHALL have a value of type Annotation",
            "expression" : "parameter.where(part.where(name='path').value = 'AllergyIntolerance' and part.where(name='name').value = 'note').exists() implies parameter.where(part.where(name='path').value = 'AllergyIntolerance' and part.where(name='name').value = 'note').part.where(name='value').value is Annotation",
            "source" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance"
          },
          {
            "key" : "shc-patch-allergy-intolerance-03",
            "severity" : "error",
            "human" : "When the part parameter named 'path' has a value of 'AllergyIntolerance.note[0]' and the part parameter named 'name' has a value of 'text', the part parameter named 'value' SHALL have a value of type markdown",
            "expression" : "parameter.where(part.where(name='path').value = 'AllergyIntolerance.note[0]' and part.where(name='name').value = 'text').exists() implies parameter.where(part.where(name='path').value = 'AllergyIntolerance.note[0]' and part.where(name='name').value = 'text').part.where(name='value').value is markdown",
            "source" : "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance"
          }
        ]
      },
      {
        "id" : "Parameters.parameter",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.name",
        "fixedString" : "operation",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part",
        "path" : "Parameters.parameter.part",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 4
      },
      {
        "id" : "Parameters.parameter.part:type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part",
        "sliceName" : "type",
        "short" : "Patch operation to perform",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:type.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "type",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:type.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "add",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:path",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part",
        "sliceName" : "path",
        "short" : "Where to perform the operation",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:path.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "path",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:path.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://smartforms.csiro.au/ig/ValueSet/SHCPatchAllergyIntoleranceElementPath"
        }
      },
      {
        "id" : "Parameters.parameter.part:name",
        "path" : "Parameters.parameter.part",
        "sliceName" : "name",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Parameters.parameter.part:name.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "name",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:name.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://smartforms.csiro.au/ig/ValueSet/SHCPatchAllergyIntoleranceElementName"
        }
      },
      {
        "id" : "Parameters.parameter.part:value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part",
        "sliceName" : "value",
        "short" : "Replacement value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "value",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1,
        "type" : [
          {
            "code" : "markdown"
          },
          {
            "code" : "Annotation"
          },
          {
            "code" : "CodeableConcept"
          }
        ],
        "condition" : [
          "shc-patch-allergy-intolerance-01",
          "shc-patch-allergy-intolerance-02",
          "shc-patch-allergy-intolerance-03"
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueCodeableConcept",
        "path" : "Parameters.parameter.part.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://smartforms.csiro.au/ig/ValueSet/AllergyIntoleranceClinicalStatusMinimal"
        }
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueMarkdown",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "sliceName" : "valueMarkdown",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "markdown"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueAnnotation",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "sliceName" : "valueAnnotation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Annotation"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:value.value[x]:valueAnnotation.text",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:process"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCHostFHIRServer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x].text",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:pathLabel",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part",
        "sliceName" : "pathLabel",
        "short" : "Human readable representation of the path. Typically this is the relevant item text from the Questionnaire.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:pathLabel.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.name",
        "fixedString" : "pathLabel",
        "mustSupport" : true
      },
      {
        "id" : "Parameters.parameter.part:pathLabel.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://smartforms.csiro.au/ig/ActorDefinition/SHCApp"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Parameters.parameter.part.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
