# ValueSet - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**Aboriginal and Torres Strait Islander Health Check - Patient Details**](Questionnaire-PatientDetails.md)
* **ValueSet**

## ValueSet: ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715/PatientDetails#australian-states-territories-2 | *Version*:0.3.0-draft |
| Draft as of 2020-05-31 | *Computable Name*:AustralianStatesAndTerritories |
| *Other Identifiers:*OID:1.2.36.1.2001.1004.201.10026 | |
| **Copyright/Legal**: Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/.This resource includes material that is based on Australian Institute of Health and Welfare material.All copies of this resource must include this copyright statement and all information contained in this statement. | |

 
The Australian States and Territories value set includes values that represent the Australian states and territories. 

 **References** 

* [Australian Address](http://hl7.org.au/fhir/6.0.0-ballot/StructureDefinition-au-address.html)

### Logical Definition (CLD)

Profiles: [Shareable ValueSet](http://hl7.org/fhir/R4/shareablevalueset.html), `https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4`

* Include these codes as defined in [`https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1`](https://tx.ontoserver.csiro.au/fhir)version ⏿1.1.3

 

### Expansion

Expansion based on [codesystem Australian States and Territories v1.1.3 (CodeSystem)](https://tx.ontoserver.csiro.au/fhir/ValueSet/australian-states-territories-1)

This value set contains 9 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

