# ValueSet - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**Aboriginal and Torres Strait Islander Health Check - Regular Medications**](Questionnaire-RegularMedications.md)
* **ValueSet**

## ValueSet: ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715/RegularMedications#MedicationStatementStatusLimited | *Version*:0.3.0-draft |
| Draft | *Computable Name*:MedicationStatementStatusLimited |

 
This value set includes the minimal set of codes to represent the status of a medication statement (i.e., active, completed, stopped and on-hold). 

 **References** 

* [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

### Logical Definition (CLD)

* Include these codes as defined in [`http://hl7.org/fhir/CodeSystem/medication-statement-status`](http://hl7.org/fhir/R4/codesystem-medication-statement-status.html)version 📦4.0.1

 

### Expansion

Expansion based on [codesystem Medication status codes v4.0.1 (CodeSystem)](http://hl7.org/fhir/R4/codesystem-medication-statement-status.html)

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

