# Profiles and Extensions - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* **Profiles and Extensions**

## Profiles and Extensions

### Profiles

The following profiles have been defined for this implementation guide.

#### AllergyIntolerance

* [Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md)

#### Bundle

* [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)

#### Condition

* [Smart Health Checks Condition](StructureDefinition-SHCCondition.md)

#### Encounter

* [Smart Health Checks Encounter](StructureDefinition-SHCEncounter.md)

#### Immunization

* [Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md)

#### Medication

* [Smart Health Checks Medication](StructureDefinition-SHCMedication.md)

#### MedicationStatement

* [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md)

#### Observation

* [Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md)
* [Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md)
* [Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md)
* [Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md)
* [Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md)
* [Smart Health Checks Pathology Result](StructureDefinition-SHCPathologyResult.md)
* [Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md)
* [Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md)
* [AU Core Head Circumference](StructureDefinition-au-core-headcircum.md) 
* [Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md)
 

#### Parameters

* [Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)
* [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)
* [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

#### Patient

* [Smart Health Checks Patient](StructureDefinition-SHCPatient.md)

#### Practitioner

* [Smart Health Checks Practitioner](StructureDefinition-SHCPractitioner.md)

#### QuestionnaireResponse

* [Smart Health Checks Questionnaire Response](StructureDefinition-SHCQuestionnaireResponse.md)

There are additional profiles used in this guide defined in [AU Core](https://hl7.org.au/fhir/core/2.0.0-ballot/).

### Extensions

The following [extensions](http://hl7.org/fhir/R4/extensibility.html) have been defined as part of this guide. A [registry of standard extensions](http://hl7.org/fhir/R4/extensibility-registry.html) can be found in the FHIR specification and additional extensions may be registered on the HL7 FHIR registry at [http://hl7.org/fhir/registry](http://hl7.org/fhir/registry).

* [Contained Resource Reference](StructureDefinition-ContainedResourceReference.md)
* [Group Hide Add Item Button](StructureDefinition-GroupHideAddItemButton.md)
* [Questionnaire Initial Expression Repopulatable](StructureDefinition-questionnaire-initialExpression-repopulatable.md)
* [Questionnaire Item Text Hidden](StructureDefinition-QuestionnaireItemTextHidden.md)
* [Template Extract Extension Patch Request URL](StructureDefinition-TemplateExtractExtensionPatchRequestUrl.md)

