# sdc-template-extract-928bbdd27d15 - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **sdc-template-extract-928bbdd27d15**

## Example Bundle: sdc-template-extract-928bbdd27d15

Profile: [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)

Tag: @aehrc/sdc-template-extract-v0.1.0:generated (Details: [not stated] code @aehrc/sdc-template-extract-v0.1.0:generated)

Bundle sdc-template-extract-928bbdd27d15 of type transaction

-------

Entry 1 - fullUrl = urn:uuid:c618ee3d-b07b-4711-90f5-56d934b906de

Resource Condition:

> 

Profile: [Smart Health Checks Condition](StructureDefinition-SHCCondition.md)

**clinicalStatus**:Active**category**:Problem List Item**code**:Asthma**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**onset**: 2025-07-01**note**:
> 

Difficulty breathing



Request:

```
POST Condition

```

-------

Entry 2 - fullUrl = urn:uuid:81c413e3-46e4-4f9f-96f5-c71983f6ffcd

Resource Condition:

> 

Profile: [Smart Health Checks Condition](StructureDefinition-SHCCondition.md)

**clinicalStatus**:Active**category**:Problem List Item**code**:Really bad pain**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**onset**: 2025-08-13

Request:

```
POST Condition

```

-------

Entry 3 - fullUrl = urn:uuid:ffb87c39-5fa8-4ea7-92c1-83911ecf33a7

Resource Parameters:

> 

Profile: [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)

## Parameters


Request:

```
PATCH Condition/fever-pat-sf

```

-------

Entry 4 - fullUrl = urn:uuid:f23b4046-2326-4c86-b4f6-1e8b6f6f7321

Resource MedicationStatement:

> 

Profile: [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md)

**status**: active**status**: recorded**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**dateAsserted**: 2025-08-15 10:08:34+1000**note**:
> 

Review regularly


### Dosages

| | |
| :--- | :--- |
| - | **Text** |
| * | One tablet daily |


Request:

```
POST MedicationStatement

```

-------

Entry 5 - fullUrl = urn:uuid:319646e0-cba5-405f-9b2d-b64f22c12876

Resource Parameters:

> 

Profile: [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

## Parameters


Request:

```
PATCH MedicationStatement/chloramphenicol-pat-sf

```

-------

Entry 6 - fullUrl = urn:uuid:c8a97d6f-d0d5-4561-ab83-2607b3bb072f

Resource Parameters:

> 

Profile: [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

## Parameters


Request:

```
PATCH MedicationStatement/active-bisoprolol-pat-sf

```

-------

Entry 7 - fullUrl = urn:uuid:e1f31c73-cb18-4ddd-aacb-26d59de074ba

Resource AllergyIntolerance:

> 

Profile: [Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md)

**clinicalStatus**:Active**code**:Aspirin**patient**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**note**:
> 

Moderate reaction


### Reactions

| | |
| :--- | :--- |
| - | **Manifestation** |
| * | No display for AllergyIntolerance.reaction.manifestation (concept: Urticaria) |


Request:

```
POST AllergyIntolerance

```

-------

Entry 8 - fullUrl = urn:uuid:346d80b8-9aef-42eb-a794-bbb74774ff7f

Resource Parameters:

> 

Profile: [Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)

## Parameters


Request:

```
PATCH AllergyIntolerance/604a-pat-sf

```

-------

Entry 9 - fullUrl = urn:uuid:29c3f6e2-4789-4114-8faf-95d250fc1986

Resource Observation:

> 

Profile: [Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md)

**status**: Final**category**:Social History**code**:Smoking status**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**:Ex-smoker

Request:

```
POST Observation

```

-------

Entry 10 - fullUrl = urn:uuid:9c321cfb-0218-455e-a44b-4c6c65afc40e

Resource Immunization:

> 

Profile: [Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md)

**status**: Completed**vaccineCode**:Fluquadri 2025**lotNumber**: 123**patient**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**occurrence**: 2025-08-15

Request:

```
POST Immunization

```

-------

Entry 11 - fullUrl = urn:uuid:559e4dda-ee0d-46c2-9f32-0bb66d9ae5e2

Resource Observation:

> 

Profile: [Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md)

**status**: Final**category**:Vital Signs**code**:Height**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**: 164 cm(Details: UCUM codecm = 'cm')

Request:

```
POST Observation

```

-------

Entry 12 - fullUrl = urn:uuid:20e79d0a-17cc-4e0a-9507-b441815ec266

Resource Observation:

> 

Profile: [Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md)

**status**: Final**category**:Vital Signs**code**:Weight**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**: 80 kg(Details: UCUM codekg = 'kg')

Request:

```
POST Observation

```

-------

Entry 13 - fullUrl = urn:uuid:553b15aa-fa22-4290-bcfb-f683ad6d6674

Resource Observation:

> 

Profile: [Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md)

**status**: Final**category**:Vital Signs**code**:Waist circumference**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**: 90 cm(Details: UCUM codecm = 'cm')

Request:

```
POST Observation

```

-------

Entry 14 - fullUrl = urn:uuid:1d0cce77-432d-42d7-a9be-5711972e7953

Resource Observation:

> 

Profile: [Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md)

**status**: Final**category**:Vital Signs**code**:Heart rate**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**: 75 /min(Details: UCUM code/min = '/min')

Request:

```
POST Observation

```

-------

Entry 15 - fullUrl = urn:uuid:3583d16f-a22f-4f03-8251-1d5d04ea87de

Resource Observation:

> 

Profile: [Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md)

**status**: Final**category**:Vital Signs**code**:Heart rhythm**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15**value**:Regular heart rhythm

Request:

```
POST Observation

```

-------

Entry 16 - fullUrl = urn:uuid:37e726d5-6ccd-4c81-ad8f-abc3460a645f

Resource Observation:

> 

Profile: [Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md)

**status**: Final**category**:Vital Signs**code**:Blood pressure**subject**:[Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --> 2024-08))](Patient-pat-sf.md)**effective**: 2025-08-15
> **component****code**:Systolic**value**: 170 mm[Hg](Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**:Diastolic**value**: 90 mm[Hg](Details: UCUM codemm[Hg] = 'mm[Hg]')

Request:

```
POST Observation

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "sdc-template-extract-928bbdd27d15",
  "meta" : {
    "profile" : [
      "https://smartforms.csiro.au/ig/StructureDefinition/SHCExtractBundle"
    ],
    "tag" : [
      {
        "code" : "@aehrc/sdc-template-extract-v0.1.0:generated"
      }
    ]
  },
  "type" : "transaction",
  "timestamp" : "2025-08-15T00:08:34.723Z",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:c618ee3d-b07b-4711-90f5-56d934b906de",
      "resource" : {
        "resourceType" : "Condition",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCCondition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCCondition.html\">Smart Health Checks Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 195967001}\">Asthma</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>onset</b>: 2025-07-01</p><p><b>note</b>: </p><blockquote><div><p>Difficulty breathing</p>\n</div></blockquote></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "195967001",
              "display" : "Asthma"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "onsetDateTime" : "2025-07-01",
        "note" : [
          {
            "text" : "Difficulty breathing"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Condition"
      }
    },
    {
      "fullUrl" : "urn:uuid:81c413e3-46e4-4f9f-96f5-c71983f6ffcd",
      "resource" : {
        "resourceType" : "Condition",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCCondition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCCondition.html\">Smart Health Checks Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:\">Really bad pain</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>onset</b>: 2025-08-13</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item"
              }
            ]
          }
        ],
        "code" : {
          "text" : "Really bad pain"
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "onsetDateTime" : "2025-08-13"
      },
      "request" : {
        "method" : "POST",
        "url" : "Condition"
      }
    },
    {
      "fullUrl" : "urn:uuid:ffb87c39-5fa8-4ea7-92c1-83911ecf33a7",
      "resource" : {
        "resourceType" : "Parameters",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchCondition"
          ]
        },
        "parameter" : [
          {
            "name" : "operation",
            "part" : [
              {
                "name" : "type",
                "valueCode" : "add"
              },
              {
                "name" : "path",
                "valueString" : "Condition"
              },
              {
                "name" : "name",
                "valueString" : "clinicalStatus"
              },
              {
                "name" : "value",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
                      "code" : "inactive",
                      "display" : "Inactive"
                    }
                  ]
                }
              },
              {
                "name" : "pathLabel",
                "valueString" : "Clinical status"
              }
            ]
          },
          {
            "name" : "operation",
            "part" : [
              {
                "name" : "type",
                "valueCode" : "add"
              },
              {
                "name" : "path",
                "valueString" : "Condition"
              },
              {
                "name" : "name",
                "valueString" : "abatement"
              },
              {
                "name" : "value",
                "valueDateTime" : "2025-08-15"
              },
              {
                "name" : "pathLabel",
                "valueString" : "Abatement date"
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "PATCH",
        "url" : "Condition/fever-pat-sf"
      }
    },
    {
      "fullUrl" : "urn:uuid:f23b4046-2326-4c86-b4f6-1e8b6f6f7321",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedicationStatement"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCMedicationStatement.html\">Smart Health Checks MedicationStatement</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <span title=\"Codes:{http://snomed.info/sct 85332011000036101}\">Coveram 10 mg/10 mg (perindopril arginine/amlodipine) tablet</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>dateAsserted</b>: 2025-08-15 10:08:34+1000</p><p><b>reasonCode</b>: <span title=\"Codes:{http://snomed.info/sct 38341003}\">Hypertension</span></p><p><b>note</b>: </p><blockquote><div><p>Review regularly</p>\n</div></blockquote><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Text</b></td></tr><tr><td style=\"display: none\">*</td><td>One tablet daily</td></tr></table></div>"
        },
        "status" : "active",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "85332011000036101",
              "display" : "Coveram 10 mg/10 mg (perindopril arginine/amlodipine) tablet"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "dateAsserted" : "2025-08-15T10:08:34.551+10:00",
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "38341003",
                "display" : "Hypertension"
              }
            ]
          }
        ],
        "note" : [
          {
            "text" : "Review regularly"
          }
        ],
        "dosage" : [
          {
            "text" : "One tablet daily"
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "MedicationStatement"
      }
    },
    {
      "fullUrl" : "urn:uuid:319646e0-cba5-405f-9b2d-b64f22c12876",
      "resource" : {
        "resourceType" : "Parameters",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          ]
        },
        "parameter" : [
          {
            "name" : "operation",
            "part" : [
              {
                "name" : "type",
                "valueCode" : "add"
              },
              {
                "name" : "path",
                "valueString" : "MedicationStatement"
              },
              {
                "name" : "name",
                "valueString" : "status"
              },
              {
                "name" : "value",
                "valueCode" : "completed"
              },
              {
                "name" : "pathLabel",
                "valueString" : "Status"
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "PATCH",
        "url" : "MedicationStatement/chloramphenicol-pat-sf"
      }
    },
    {
      "fullUrl" : "urn:uuid:c8a97d6f-d0d5-4561-ab83-2607b3bb072f",
      "resource" : {
        "resourceType" : "Parameters",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          ]
        },
        "parameter" : [
          {
            "name" : "operation",
            "part" : [
              {
                "name" : "type",
                "valueCode" : "add"
              },
              {
                "name" : "path",
                "valueString" : "MedicationStatement.dosage[0]"
              },
              {
                "name" : "name",
                "valueString" : "text"
              },
              {
                "name" : "value",
                "valueString" : "1 tablet in the morning."
              }
            ]
          },
          {
            "name" : "operation",
            "part" : [
              {
                "name" : "type",
                "valueCode" : "add"
              },
              {
                "name" : "path",
                "valueString" : "MedicationStatement"
              },
              {
                "name" : "name",
                "valueString" : "note"
              },
              {
                "name" : "pathLabel",
                "valueString" : "Comment"
              },
              {
                "name" : "value",
                "valueAnnotation" : {
                  "text" : "Monitor following increased dosage."
                }
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "PATCH",
        "url" : "MedicationStatement/active-bisoprolol-pat-sf"
      }
    },
    {
      "fullUrl" : "urn:uuid:e1f31c73-cb18-4ddd-aacb-26d59de074ba",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCAllergyIntolerance"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCAllergyIntolerance.html\">Smart Health Checks AllergyIntolerance</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 387458008}\">Aspirin</span></p><p><b>patient</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>note</b>: </p><blockquote><div><p>Moderate reaction</p>\n</div></blockquote><h3>Reactions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Manifestation</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 126485001}\">Urticaria</span></td></tr></table></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "387458008",
              "display" : "Aspirin"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/pat-sf"
        },
        "note" : [
          {
            "text" : "Moderate reaction"
          }
        ],
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "126485001",
                    "display" : "Urticaria"
                  }
                ]
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "AllergyIntolerance"
      }
    },
    {
      "fullUrl" : "urn:uuid:346d80b8-9aef-42eb-a794-bbb74774ff7f",
      "resource" : {
        "resourceType" : "Parameters",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance"
          ]
        },
        "parameter" : [
          {
            "name" : "operation",
            "part" : [
              {
                "name" : "type",
                "valueCode" : "add"
              },
              {
                "name" : "path",
                "valueString" : "AllergyIntolerance"
              },
              {
                "name" : "name",
                "valueString" : "clinicalStatus"
              },
              {
                "name" : "value",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
                      "code" : "inactive",
                      "display" : "Inactive"
                    }
                  ]
                }
              },
              {
                "name" : "pathLabel",
                "valueString" : "Clinical status"
              }
            ]
          },
          {
            "name" : "operation",
            "part" : [
              {
                "name" : "type",
                "valueCode" : "add"
              },
              {
                "name" : "path",
                "valueString" : "AllergyIntolerance.note[0]"
              },
              {
                "name" : "name",
                "valueString" : "text"
              },
              {
                "name" : "value",
                "valueMarkdown" : "Duplicated allergy in record. Made inactive."
              },
              {
                "name" : "pathLabel",
                "valueString" : "Comment"
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "PATCH",
        "url" : "AllergyIntolerance/604a-pat-sf"
      }
    },
    {
      "fullUrl" : "urn:uuid:29c3f6e2-4789-4114-8faf-95d250fc1986",
      "resource" : {
        "resourceType" : "Observation",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCSmokingStatus"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCSmokingStatus.html\">Smart Health Checks Smoking Status</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category social-history}\">Social History</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 1747861000168109}, {http://loinc.org 72166-2}\">Smoking status</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>effective</b>: 2025-08-15</p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 8517006}\">Ex-smoker</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "social-history"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1747861000168109"
            },
            {
              "system" : "http://loinc.org",
              "code" : "72166-2"
            }
          ],
          "text" : "Smoking status"
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "effectiveDateTime" : "2025-08-15",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "8517006",
              "display" : "Ex-smoker"
            }
          ]
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:9c321cfb-0218-455e-a44b-4c6c65afc40e",
      "resource" : {
        "resourceType" : "Immunization",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCImmunization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCImmunization.html\">Smart Health Checks Immunization</a></p></div><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://snomed.info/sct 884862121000036103}\">Fluquadri 2025</span></p><p><b>patient</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>occurrence</b>: 2025-08-15</p><p><b>lotNumber</b>: 123</p></div>"
        },
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "884862121000036103",
              "display" : "Fluquadri 2025"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/pat-sf"
        },
        "occurrenceDateTime" : "2025-08-15",
        "lotNumber" : "123"
      },
      "request" : {
        "method" : "POST",
        "url" : "Immunization"
      }
    },
    {
      "fullUrl" : "urn:uuid:559e4dda-ee0d-46c2-9f32-0bb66d9ae5e2",
      "resource" : {
        "resourceType" : "Observation",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyHeight"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCBodyHeight.html\">Smart Health Checks Body Height</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8302-2}, {http://snomed.info/sct 50373000}\">Height</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>effective</b>: 2025-08-15</p><p><b>value</b>: 164 cm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codecm = 'cm')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8302-2"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "50373000"
            }
          ],
          "text" : "Height"
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "effectiveDateTime" : "2025-08-15",
        "valueQuantity" : {
          "value" : 164,
          "unit" : "cm",
          "system" : "http://unitsofmeasure.org",
          "code" : "cm"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:20e79d0a-17cc-4e0a-9507-b441815ec266",
      "resource" : {
        "resourceType" : "Observation",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyWeight"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCBodyWeight.html\">Smart Health Checks Body Weight</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 29463-7}, {http://snomed.info/sct 27113001}\">Weight</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>effective</b>: 2025-08-15</p><p><b>value</b>: 80 kg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codekg = 'kg')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29463-7"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "27113001"
            }
          ],
          "text" : "Weight"
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "effectiveDateTime" : "2025-08-15",
        "valueQuantity" : {
          "value" : 80,
          "unit" : "kg",
          "system" : "http://unitsofmeasure.org",
          "code" : "kg"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:553b15aa-fa22-4290-bcfb-f683ad6d6674",
      "resource" : {
        "resourceType" : "Observation",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCWaistCircumference"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCWaistCircumference.html\">Smart Health Checks Waist Circumference</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8280-0}, {http://snomed.info/sct 276361009}\">Waist circumference</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>effective</b>: 2025-08-15</p><p><b>value</b>: 90 cm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codecm = 'cm')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8280-0"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "276361009"
            }
          ],
          "text" : "Waist circumference"
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "effectiveDateTime" : "2025-08-15",
        "valueQuantity" : {
          "value" : 90,
          "unit" : "cm",
          "system" : "http://unitsofmeasure.org",
          "code" : "cm"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:1d0cce77-432d-42d7-a9be-5711972e7953",
      "resource" : {
        "resourceType" : "Observation",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRate"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCHeartRate.html\">Smart Health Checks Heart Rate</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8867-4}, {http://snomed.info/sct 364075005}\">Heart rate</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>effective</b>: 2025-08-15</p><p><b>value</b>: 75 /min<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code/min = '/min')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8867-4"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "364075005"
            }
          ],
          "text" : "Heart rate"
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "effectiveDateTime" : "2025-08-15",
        "valueQuantity" : {
          "value" : 75,
          "unit" : "/min",
          "system" : "http://unitsofmeasure.org",
          "code" : "/min"
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:3583d16f-a22f-4f03-8251-1d5d04ea87de",
      "resource" : {
        "resourceType" : "Observation",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRhythm"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCHeartRhythm.html\">Smart Health Checks Heart Rhythm</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8884-9}, {http://snomed.info/sct 364074009}\">Heart rhythm</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>effective</b>: 2025-08-15</p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 933506231000036108}\">Regular heart rhythm</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8884-9"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "364074009"
            }
          ],
          "text" : "Heart rhythm"
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "effectiveDateTime" : "2025-08-15",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "933506231000036108",
              "display" : "Regular heart rhythm"
            }
          ]
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    },
    {
      "fullUrl" : "urn:uuid:37e726d5-6ccd-4c81-ad8f-abc3460a645f",
      "resource" : {
        "resourceType" : "Observation",
        "meta" : {
          "profile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBloodPressure"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_null\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation </b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-SHCBloodPressure.html\">Smart Health Checks Blood Pressure</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 85354-9}, {http://snomed.info/sct 75367002}\">Blood pressure</span></p><p><b>subject</b>: <a href=\"Patient-pat-sf.html\">Clever Form Female, DoB: 1968-10-11 ( Medicare Number: 69514496771 (, period: (?) --&gt; 2024-08))</a></p><p><b>effective</b>: 2025-08-15</p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8480-6}, {http://snomed.info/sct 271649006}\">Systolic</span></p><p><b>value</b>: 170 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8462-4}, {http://snomed.info/sct 271650006}\">Diastolic</span></p><p><b>value</b>: 90 mm[Hg]<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemm[Hg] = 'mm[Hg]')</span></p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85354-9"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "75367002"
            }
          ],
          "text" : "Blood pressure"
        },
        "subject" : {
          "reference" : "Patient/pat-sf"
        },
        "effectiveDateTime" : "2025-08-15",
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8480-6"
                },
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "271649006"
                }
              ],
              "text" : "Systolic"
            },
            "valueQuantity" : {
              "value" : 170,
              "unit" : "mm[Hg]",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8462-4"
                },
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "271650006"
                }
              ],
              "text" : "Diastolic"
            },
            "valueQuantity" : {
              "value" : 90,
              "unit" : "mm[Hg]",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "Observation"
      }
    }
  ]
}

```
