# SHC Host FHIR Server - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SHC Host FHIR Server**

## CapabilityStatement: SHC Host FHIR Server 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/CapabilityStatement/SHCHostFHIRServerCapabilityStatement | *Version*:0.3.0-draft |
| Draft as of 2025-04-16 | *Computable Name*:SHCHostFHIRServer |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
This CapabilityStatement describes the expected capabilities for systems to launch and exchange data with the[SHC App](CapabilityStatement-SHCAppCapabilityStatement.md)to support the[Aboriginal and Torres Strait Islander Health Check](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.md). It lists the server's conformance expectations for the resource types required as a launch context, resource types required to support prepopulation of the form, resource types required to support writing back to the patient record, and QuestionnaireResponse requirements for managing form responses. These expectations include supported FHIR profiles, RESTful operations, and search parameters. 

 [Raw OpenAPI-Swagger Definition file](SHCHostFHIRServerCapabilityStatement.openapi.json) | [Download](SHCHostFHIRServerCapabilityStatement.openapi.json) 

## SHC Host FHIR Server

* Implementation Guide Version: 0.3.0-draft 
* FHIR Version: 4.0.1 
* Supported Formats: **SHALL** support `json`
* Supported Patch Formats: **SHALL** support `application/fhir+json`
* Published on: 2025-04-16 
* Published by: AEHRC CSIRO 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

### SHALL Support the Following Implementation Guides

* [http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch|2.2.0](http://hl7.org/fhir/smart-app-launch/STU2.2/index.html)

### SHOULD Support the Following Implementation Guides

* [http://hl7.org/fhir/uv/sdc/ImplementationGuide/hl7.fhir.uv.sdc](http://hl7.org/fhir/uv/sdc/2025Jan/index.html)

## FHIR RESTful Capabilities

### Mode: server

Smart Forms Launcher Server **SHALL**:

1. Support the[Smart Health Checks AllergyIntolerance resource profile](StructureDefinition-SHCAllergyIntolerance.md)
1. Support the[Smart Health Checks Condition resource profile](StructureDefinition-SHCCondition.md)
1. Support the[Smart Health Checks Encounter resource profile](StructureDefinition-SHCEncounter.md)
1. Support the[Smart Health Checks Immunization resource profile](StructureDefinition-SHCImmunization.md)
1. Support the[Smart Health Checks Medication profile](StructureDefinition-SHCMedication.md)
1. Support the[Smart Health Checks MedicationStatement profile](StructureDefinition-SHCMedicationStatement.md)
1. Support the[Smart Health Checks Observation resource profiles](profiles-and-extensions.md#observation)
1. Support the[Smart Health Checks Patient resource profile](StructureDefinition-SHCPatient.md)
1. Support the[Smart Health Checks Practitioner resource profile](StructureDefinition-SHCPractitioner.md)
1. Support the[Smart Health Checks QuestionnaireResponse resource profile](StructureDefinition-SHCQuestionnaireResponse.md)
1. Support the[Smart Health Checks Patch AllergyIntolerance profile](StructureDefinition-SHCPatchAllergyIntolerance.md)
1. Support the[Smart Health Checks Patch Condition profile](StructureDefinition-SHCPatchCondition.md)
1. Support the[Smart Health Checks Patch MedicationStatement profile](StructureDefinition-SHCPatchMedicationStatement.md)
1. Support the[Smart Health Checks Extract Bundle resource profile](StructureDefinition-SHCExtractBundle.md)
1. Implement the RESTful behavior according to the FHIR specification
1. Support JSON source formats for all interactions

**Security**

Enable CORS: yes

Security services supported:
`SMART-on-FHIR`

> 

Smart Forms Launcher Server **SHALL**:

1. Support CORS headers
1. Support SMART on FHIR security services

Also see the [AU Core Security and Privacy](https://hl7.org.au/fhir/core/2.0.0-ballot/security.html) section for general considerations and recommendations.


**Summary of System-wide Interactions**

* **SHALL**support the `transaction`interaction described as follows:

The server **SHALL** support the transaction interaction for all resources.


### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AllergyIntolerance](#AllergyIntolerance1-1) | Supported Profiles  [Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md) |  | **Y** |  | **Y** | **Y** | patient |  |  |  |
| [Bundle](#Bundle1-2) | Supported Profiles  [Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md) |  |  |  |  |  |  |  |  |  |
| [Condition](#Condition1-3) | Supported Profiles  [Smart Health Checks Condition](StructureDefinition-SHCCondition.md) |  | **Y** |  | **Y** | **Y** | patient, category, patient+category |  |  |  |
| [Encounter](#Encounter1-4) | Supported Profiles  [Smart Health Checks Encounter](StructureDefinition-SHCEncounter.md) | **Y** |  |  |  |  |  |  |  |  |
| [Immunization](#Immunization1-5) | Supported Profiles  [Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md) |  | **Y** |  |  | **Y** | patient, status, patient+status |  |  |  |
| [Medication](#Medication1-6) | Supported Profiles  [Smart Health Checks Medication](StructureDefinition-SHCMedication.md) | **Y** |  |  |  |  |  |  |  |  |
| [MedicationStatement](#MedicationStatement1-7) | Supported Profiles  [Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md) |  | **Y** |  | **Y** | **Y** | patient, status, _include, patient+status, patient+status+_include | `MedicationStatement:medication` |  |  |
| [Observation](#Observation1-8) | Supported Profiles  [Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md)  [Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md)  [Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md)  [Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md)  [Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md)  [Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md)  [Smart Health Checks Pathology Result](StructureDefinition-SHCPathologyResult.md)  [Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md)  [Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md) |  | **Y** |  |  | **Y** | patient, code, _sort, patient+code+_sort |  |  |  |
| [Parameters](#Parameters1-9) | Supported Profiles  [Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)  [Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)  [Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md) |  |  |  |  |  |  |  |  |  |
| [Patient](#Patient1-10) | Supported Profiles  [Smart Health Checks Patient](StructureDefinition-SHCPatient.md) | **Y** |  |  |  |  |  |  |  |  |
| [Practitioner](#Practitioner1-11) | Supported Profiles  [Smart Health Checks Practitioner](StructureDefinition-SHCPractitioner.md) | **Y** |  |  |  |  |  |  |  |  |
| [QuestionnaireResponse](#QuestionnaireResponse1-12) | Supported Profiles  [Smart Health Checks Questionnaire Response](StructureDefinition-SHCQuestionnaireResponse.md) | **Y** | **Y** | **Y** |  | **Y** | patient, questionnaire, status, _count, _sort, patient+_count+_sort, patient+_count+_sort+questionnaire, patient+_count+_sort+status |  |  |  |

-------

#### Resource Conformance: SHALL AllergyIntolerance

Core FHIR Resource

[AllergyIntolerance](http://hl7.org/fhir/R4/allergyintolerance.html)

Reference Policy

Interaction summary

* **SHALL** support `search-type`, `create`, `patch`.

Supported Profiles
[Smart Health Checks AllergyIntolerance](StructureDefinition-SHCAllergyIntolerance.md)

Documentation
> 

The server **SHALL** support the AllergyIntolerance resource, the Smart Health Checks profile and the conformance expectations for the AllergyIntolerance resource.


Search Parameters


 

#### Resource Conformance: SHALL Bundle

Core FHIR Resource

[Bundle](http://hl7.org/fhir/R4/bundle.html)

Reference Policy

Interaction summary

Supported Profiles
[Smart Health Checks Extract Bundle](StructureDefinition-SHCExtractBundle.md)

Documentation
> 

The server **SHALL** support the Bundle resource, the Smart Health Checks profile listed and the conformance expectations for the Bundle resource.


#### Resource Conformance: SHALL Condition

Core FHIR Resource

[Condition](http://hl7.org/fhir/R4/condition.html)

Reference Policy

Interaction summary

* **SHALL** support `search-type`, `create`, `patch`.

Supported Profiles
[Smart Health Checks Condition](StructureDefinition-SHCCondition.md)

Documentation
> 

The server **SHALL** support the Condition resource, the Smart Health Checks profile and the conformance expectations for the Condition resource.


Search Parameters


Combined Search Parameters


#### Resource Conformance: SHALL Encounter

Core FHIR Resource

[Encounter](http://hl7.org/fhir/R4/encounter.html)

Reference Policy

Interaction summary

* **SHALL** support `read`.

Supported Profiles
[Smart Health Checks Encounter](StructureDefinition-SHCEncounter.md)

Documentation
> 

The server **SHALL** support the Encounter resource, Smart Health Checks profile and the conformance expectations for the Encounter resource.


#### Resource Conformance: SHALL Immunization

Core FHIR Resource

[Immunization](http://hl7.org/fhir/R4/immunization.html)

Reference Policy

Interaction summary

* **SHALL** support `search-type`, `create`.

Supported Profiles
[Smart Health Checks Immunization](StructureDefinition-SHCImmunization.md)

Documentation
> 

The server **SHALL** support the Immunization resource, the Smart Health Checks profile and the conformance expectations for the Immunization resource.


Search Parameters


Combined Search Parameters


#### Resource Conformance: MAY Medication

Core FHIR Resource

[Medication](http://hl7.org/fhir/R4/medication.html)

Reference Policy

Interaction summary

* **SHALL** support `read`.

Supported Profiles
[Smart Health Checks Medication](StructureDefinition-SHCMedication.md)

Documentation
> 

If an external reference to a Medication resource is used in MedicationStatement, then the server **SHALL** support the Medication resource, the Smart Health Checks profile and the conformance expectations for the Medication resource.


#### Resource Conformance: SHALL MedicationStatement

Core FHIR Resource

[MedicationStatement](http://hl7.org/fhir/R4/medicationstatement.html)

Reference Policy

Interaction summary

* **SHALL** support `search-type`, `create`, `patch`.

Supported Profiles
[Smart Health Checks MedicationStatement](StructureDefinition-SHCMedicationStatement.md)

Documentation
> 

The server **SHALL** support the MedicationStatement resource, the Smart Health Checks profile and the conformance expectations for the MedicationStatement resource.

If a medication in a MedicationStatement resource is represented as an external Medication resource reference, the server **SHALL** support the `_include` parameter for searching this element (`MedicationStatement:medication`)


Search Parameters


Combined Search Parameters


#### Resource Conformance: SHALL Observation

Core FHIR Resource

[Observation](http://hl7.org/fhir/R4/observation.html)

Reference Policy

Interaction summary

* **SHALL** support `search-type`, `create`.

Supported Profiles
[Smart Health Checks Blood Pressure](StructureDefinition-SHCBloodPressure.md)
[Smart Health Checks Body Height](StructureDefinition-SHCBodyHeight.md)
[Smart Health Checks Body Weight](StructureDefinition-SHCBodyWeight.md)
[Smart Health Checks Head Circumference](StructureDefinition-SHCHeadCircumference.md)
[Smart Health Checks Heart Rate](StructureDefinition-SHCHeartRate.md)
[Smart Health Checks Heart Rhythm](StructureDefinition-SHCHeartRhythm.md)
[Smart Health Checks Pathology Result](StructureDefinition-SHCPathologyResult.md)
[Smart Health Checks Smoking Status](StructureDefinition-SHCSmokingStatus.md)
[Smart Health Checks Waist Circumference](StructureDefinition-SHCWaistCircumference.md)

Documentation
> 

The server **SHALL** support the Observation resource, the Smart Health Checks profiles listed and the conformance expectations for the Observation resource.


Search Parameters


Combined Search Parameters


#### Resource Conformance: SHALL Parameters

Core FHIR Resource

[Parameters](http://hl7.org/fhir/R4/parameters.html)

Reference Policy

Interaction summary

Supported Profiles
[Smart Health Checks Patch AllergyIntolerance](StructureDefinition-SHCPatchAllergyIntolerance.md)
[Smart Health Checks Patch Condition](StructureDefinition-SHCPatchCondition.md)
[Smart Health Checks Patch MedicationStatement](StructureDefinition-SHCPatchMedicationStatement.md)

Documentation
> 

The server **SHALL** support the Parameters resource, the Smart Health Checks profile and the conformance expectations for the Parameters resource.


#### Resource Conformance: SHALL Patient

Core FHIR Resource

[Patient](http://hl7.org/fhir/R4/patient.html)

Reference Policy

Interaction summary

* **SHALL** support `read`.

Supported Profiles
[Smart Health Checks Patient](StructureDefinition-SHCPatient.md)

Documentation
> 

The server **SHALL** support the Patient resource, Smart Health Checks profile and the conformance expectations for the Patient resource.


#### Resource Conformance: SHALL Practitioner

Core FHIR Resource

[Practitioner](http://hl7.org/fhir/R4/practitioner.html)

Reference Policy

Interaction summary

* **SHALL** support `read`.

Supported Profiles
[Smart Health Checks Practitioner](StructureDefinition-SHCPractitioner.md)

Documentation
> 

The server **SHALL** support the Practitioner resource, Smart Health Checks profile and the conformance expectations for the Practitioner resource.


#### Resource Conformance: SHALL QuestionnaireResponse

Core FHIR Resource

[QuestionnaireResponse](http://hl7.org/fhir/R4/questionnaireresponse.html)

Reference Policy

Interaction summary

* **SHALL** support `read`, `search-type`, `create`, `update`.

Supported Profiles
[Smart Health Checks Questionnaire Response](StructureDefinition-SHCQuestionnaireResponse.md)

Documentation
> 

The server **SHALL** support the QuestionnaireResponse resource, Smart Health Checks profile and the conformance expectations for the QuestionnaireResponse resource.


Search Parameters


Combined Search Parameters




## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "SHCHostFHIRServerCapabilityStatement",
  "url" : "https://smartforms.csiro.au/ig/CapabilityStatement/SHCHostFHIRServerCapabilityStatement",
  "version" : "0.3.0-draft",
  "name" : "SHCHostFHIRServer",
  "title" : "SHC Host FHIR Server",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-04-16",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This CapabilityStatement describes the expected capabilities for systems to launch and exchange data with the [SHC App](CapabilityStatement-SHCAppCapabilityStatement.html) to support the [Aboriginal and Torres Strait Islander Health Check](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.html). It lists the server's conformance expectations for the resource types required as a launch context, resource types required to support prepopulation of the form, resource types required to support writing back to the patient record, and QuestionnaireResponse requirements for managing form responses. These expectations include supported FHIR profiles, RESTful operations, and search parameters.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json"],
  "_format" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    }
  ],
  "patchFormat" : ["application/fhir+json"],
  "_patchFormat" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    }
  ],
  "implementationGuide" : [
    "http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch|2.2.0",
    "http://hl7.org/fhir/uv/sdc/ImplementationGuide/hl7.fhir.uv.sdc"
  ],
  "_implementationGuide" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHOULD"
        }
      ]
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "Smart Forms Launcher Server **SHALL**:\r\n1. Support the [Smart Health Checks AllergyIntolerance resource profile](StructureDefinition-SHCAllergyIntolerance.html)\r\n1. Support the [Smart Health Checks Condition resource profile](StructureDefinition-SHCCondition.html)\r\n1. Support the [Smart Health Checks Encounter resource profile](StructureDefinition-SHCEncounter.html)\r\n1. Support the [Smart Health Checks Immunization resource profile](StructureDefinition-SHCImmunization.html)\r\n1. Support the [Smart Health Checks Medication profile](StructureDefinition-SHCMedication.html)\r\n1. Support the [Smart Health Checks MedicationStatement profile](StructureDefinition-SHCMedicationStatement.html)\r\n1. Support the [Smart Health Checks Observation resource profiles](profiles-and-extensions.html#observation)\r\n1. Support the [Smart Health Checks Patient resource profile](StructureDefinition-SHCPatient.html)\r\n1. Support the [Smart Health Checks Practitioner resource profile](StructureDefinition-SHCPractitioner.html)\r\n1. Support the [Smart Health Checks QuestionnaireResponse resource profile](StructureDefinition-SHCQuestionnaireResponse.html)\r\n1. Support the [Smart Health Checks Patch AllergyIntolerance profile](StructureDefinition-SHCPatchAllergyIntolerance.html)\r\n1. Support the [Smart Health Checks Patch Condition profile](StructureDefinition-SHCPatchCondition.html)\r\n1. Support the [Smart Health Checks Patch MedicationStatement profile](StructureDefinition-SHCPatchMedicationStatement.html)\r\n1. Support the [Smart Health Checks Extract Bundle resource profile](StructureDefinition-SHCExtractBundle.html)\r\n1. Implement the RESTful behavior according to the FHIR specification\r\n1. Support JSON source formats for all interactions",
      "security" : {
        "cors" : true,
        "_cors" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ]
        },
        "service" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ],
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "SMART-on-FHIR"
              }
            ]
          }
        ],
        "description" : "Smart Forms Launcher Server **SHALL**:\r\n1. Support CORS headers\r\n1. Support SMART on FHIR security services\r\n\r\nAlso see the [AU Core Security and Privacy](https://hl7.org.au/fhir/core/2.0.0-ballot/security.html) section for general considerations and recommendations."
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "AllergyIntolerance",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCAllergyIntolerance"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the AllergyIntolerance resource, the Smart Health Checks profile and the conformance expectations for the AllergyIntolerance resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "patch"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Bundle",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCExtractBundle"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Bundle resource, the Smart Health Checks profile listed and the conformance expectations for the Bundle resource."
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "category"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Condition",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCCondition"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Condition resource, the Smart Health Checks profile and the conformance expectations for the Condition resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "patch"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "category",
              "definition" : "http://hl7.org/fhir/SearchParameter/Condition-category",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values. \r\n\r\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Encounter",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCEncounter"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Encounter resource, Smart Health Checks profile and the conformance expectations for the Encounter resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Immunization",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCImmunization"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Immunization resource, the Smart Health Checks profile and the conformance expectations for the Immunization resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/Immunization-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values. \r\n\r\nThe server **SHALL** support both."
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Medication",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedication"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If an external reference to a Medication resource is used in MedicationStatement, then the server **SHALL** support the Medication resource, the Smart Health Checks profile and the conformance expectations for the Medication resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                },
                {
                  "url" : "required",
                  "valueString" : "_include"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "MedicationStatement",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCMedicationStatement"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the MedicationStatement resource, the Smart Health Checks profile and the conformance expectations for the MedicationStatement resource.\r\n\r\nIf a medication in a MedicationStatement resource is represented as an external Medication resource reference, the server **SHALL** support the `_include` parameter for searching this element (`MedicationStatement:medication`)\r\n",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "patch"
            }
          ],
          "searchInclude" : ["MedicationStatement:medication"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/medications-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the system and code values.\r\n\r\nThe server **SHALL** support both.\r\n\r\nThe client **SHALL** support `multipleOr`.\r\n\r\nThe server **SHALL** support `multipleOr`."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_include",
              "type" : "reference",
              "documentation" : "If a medication in a MedicationStatement resource is represented as an external Medication resource reference, the server **SHALL** support the `_include` parameter for searching this element (`MedicationStatement:medication`).\r\n\r\nThe client **SHALL** support this method."
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "code"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Observation",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBloodPressure",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyHeight",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCBodyWeight",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeadCircumference",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRate",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCHeartRhythm",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPathologyResult",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCSmokingStatus",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCWaistCircumference"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Observation resource, the Smart Health Checks profiles listed and the conformance expectations for the Observation resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both. "
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "code",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-code",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the code and system values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_sort",
              "type" : "string",
              "documentation" : "The client and server **SHALL** support search result sorting by date and **MAY** support other values."
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Parameters",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchAllergyIntolerance",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchCondition",
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatchMedicationStatement"
          ],
          "_supportedProfile" : [
            null,
            null,
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Parameters resource, the Smart Health Checks profile and the conformance expectations for the Parameters resource."
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Patient",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPatient"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Patient resource, Smart Health Checks profile and the conformance expectations for the Patient resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "Practitioner",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCPractitioner"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the Practitioner resource, Smart Health Checks profile and the conformance expectations for the Practitioner resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                },
                {
                  "url" : "required",
                  "valueString" : "questionnaire"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "_count"
                },
                {
                  "url" : "required",
                  "valueString" : "_sort"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "QuestionnaireResponse",
          "supportedProfile" : [
            "https://smartforms.csiro.au/ig/StructureDefinition/SHCQuestionnaireResponse"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "The server **SHALL** support the QuestionnaireResponse resource, Smart Health Checks profile and the conformance expectations for the QuestionnaireResponse resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update"
            }
          ],
          "versioning" : "versioned-update",
          "_versioning" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-patient",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both. "
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "questionnaire",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-questionnaire",
              "type" : "reference",
              "documentation" : "The client **SHALL** provide at least a id value and **MAY** provide both the Type and id values. \r\n\r\nThe server **SHALL** support both.\r\n\r\nThe client and server **SHALL** support chained search questionnaire.title using the :contains modifier."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/QuestionnaireResponse-status",
              "type" : "token",
              "documentation" : "The client **SHALL** provide at least a code value and **MAY** provide both the code and system values. \r\n\r\nThe server **SHALL** support both."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_count",
              "type" : "number",
              "documentation" : "The client and server **SHALL** support search result limiting."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_sort",
              "type" : "string",
              "documentation" : "The client and server **SHALL** support search result sorting by authored and **MAY** support other values."
            }
          ]
        }
      ],
      "interaction" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "code" : "transaction",
          "documentation" : "The server **SHALL** support the transaction interaction for all resources."
        }
      ]
    }
  ]
}

```
