# Questionnaire Repopulation Behavior Codes - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Questionnaire Repopulation Behavior Codes**

## CodeSystem: Questionnaire Repopulation Behavior Codes 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireRepopulationBehaviorCodes | *Version*:0.3.0-draft |
| Draft as of 2025-10-30 | *Computable Name*:QuestionnaireRepopulationBehaviorCodes |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The Questionnaire Repopulation Behavior Codes code system defines concepts that describe the repopulation behaviour that can be applied to the initial expression of a Questionnaire item. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [QuestionnaireRepopulationBehavior](ValueSet-QuestionnaireRepopulationBehavior.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "QuestionnaireRepopulationBehaviorCodes",
  "url" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireRepopulationBehaviorCodes",
  "version" : "0.3.0-draft",
  "name" : "QuestionnaireRepopulationBehaviorCodes",
  "title" : "Questionnaire Repopulation Behavior Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-30T20:31:27+10:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "The Questionnaire Repopulation Behavior Codes code system defines concepts that describe the repopulation behaviour that can be applied to the initial expression of a Questionnaire item.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 1,
  "concept" : [
    {
      "code" : "manual",
      "display" : "Manual",
      "definition" : "The item can be repopulated manually by the user. The initial expression will be evaluated and the item populated with the result."
    }
  ]
}

```
