# Questionnaire Initial Expression Repopulatable - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Questionnaire Initial Expression Repopulatable**

## Extension: Questionnaire Initial Expression Repopulatable 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/StructureDefinition/questionnaire-initialExpression-repopulatable | *Version*:0.3.0-draft |
| Draft as of 2025-10-30 | *Computable Name*:QuestionnaireInitialExpressionRepopulatable |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

This custom extension is used to add a UI component that allows a user to repopulate an individual Questionnaire item with the latest data from the FHIR server. This is useful for updating specific items without having to refresh the entire form.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [AboriginalTorresStraitIslanderHealthCheck](Questionnaire-AboriginalTorresStraitIslanderHealthCheck.md) and [AbsoluteCVDRiskCalculation](Questionnaire-AbsoluteCVDRiskCalculation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/csiro.fhir.au.smartforms|current/StructureDefinition/questionnaire-initialExpression-repopulatable)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-questionnaire-initialExpression-repopulatable.csv), [Excel](StructureDefinition-questionnaire-initialExpression-repopulatable.xlsx), [Schematron](StructureDefinition-questionnaire-initialExpression-repopulatable.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "questionnaire-initialExpression-repopulatable",
  "url" : "https://smartforms.csiro.au/ig/StructureDefinition/questionnaire-initialExpression-repopulatable",
  "version" : "0.3.0-draft",
  "name" : "QuestionnaireInitialExpressionRepopulatable",
  "title" : "Questionnaire Initial Expression Repopulatable",
  "status" : "draft",
  "date" : "2025-10-30T20:31:27+10:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "This custom extension is used to add a UI component that allows a user to repopulate an individual Questionnaire item with the latest data from the FHIR server. This is useful for updating specific items without having to refresh the entire form.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Questionnaire.item"
    }
  ],
  "contextInvariant" : [
    "(type = 'string' or type = 'text' or type = 'integer' or type = 'decimal') and (repeats=false or repeats.empty()) and (extension.where(url = 'http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression').exists())"
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Questionnaire Initial Expression Repopulatable",
        "definition" : "The value defines the repopulation behaviour of a Questionnaire item.",
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://smartforms.csiro.au/ig/StructureDefinition/questionnaire-initialExpression-repopulatable"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "code"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://smartforms.csiro.au/ig/ValueSet/QuestionnaireRepopulationBehavior"
        }
      }
    ]
  }
}

```
