# ValueSet - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**Aboriginal and Torres Strait Islander Health Check**](Questionnaire-AssemblyInstructions.md)
* **ValueSet**

## ValueSet: ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715#CervicalScreeningStatus-1 | *Version*:0.3.0-draft |
| Draft | *Computable Name*:CervicalScreeningStatus |

 
The Cervical Screening Status value set includes values that can be used to represent the status of an individual's participation in a cervical screening program. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This ValueSet requires the Code system Supplement [SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check](CodeSystem-HealthChecksSCTSupplement.md).

* Include these codes as defined in [`http://snomed.info/sct`](http://www.snomed.org/)version 📍

 

### Expansion

This ValueSet requires the Code system Supplement [SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check](CodeSystem-HealthChecksSCTSupplement.md).

Expansion based on:

* SNOMED CT Australian Edition edition 31-Oct 2025
* [supplement SNOMED CT Supplement for Aboriginal and Torres Strait Islander Health Check v0.3.0 (CodeSystem)](CodeSystem-HealthChecksSCTSupplement.md)

This value set expansion contains 4 concepts.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

