# ValueSet - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**Aboriginal and Torres Strait Islander Health Check**](Questionnaire-AssemblyInstructions.md)
* **ValueSet**

## ValueSet: ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715#YesNoNotAskedDeclined | *Version*:0.3.0-draft |
| Draft | *Computable Name*:YesNoNotAskedDeclined |

 
Concepts for Yes, No, Not Asked and Asked But Declined 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/v2-0532`](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0532.html)version 📍2.0.0
* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/data-absent-reason`](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html)version 📍1.0.0 

 

### Expansion

Expansion based on:

* [codesystem DataAbsentReason v1.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html)
* [codesystem expandedYes-NoIndicator v2.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0532.html)

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

