# ValueSet - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**Aboriginal and Torres Strait Islander Health Check**](Questionnaire-AssemblyInstructions.md)
* **ValueSet**

## ValueSet: ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715#australian-pronouns-1 | *Version*:0.3.0-draft |
| Draft as of 2024-02-29 | *Computable Name*:AustralianPronouns |
| *Other Identifiers:*OID:1.2.36.1.2001.1004.201.10284 | |
| **Copyright/Legal**: Copyright © 2024 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/.This material contains content from LOINC (http://loinc.org). LOINC is copyright 1995-2024, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the license at http://loinc.org/license. LOINC® is a registered United States trademark of Regenstrief Institute, Inc.This material contains information which is protected by copyright. You may download, display, print and reproduce any material for your personal, non-commercial use or use within your organisation subject to the following terms and conditions:This resource also includes all or a portion of material from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license. | |

 
The Australian Pronouns value set includes values that indicate the pronouns to be used when communicating with or about an individual. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include these codes as defined in [`http://loinc.org`](http://loinc.org)version Not Stated (use latest from terminology server)
* Include these codes as defined in [`http://terminology.hl7.org/CodeSystem/data-absent-reason`](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html)version 📦1.0.0 

 

### Expansion

Expansion based on:

* Loinc v2.80
* [codesystem DataAbsentReason v1.0.0 (CodeSystem)](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html)

This value set contains 7 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

