# ValueSet - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* [**Aboriginal and Torres Strait Islander Health Check - Patient Details**](Questionnaire-PatientDetails.md)
* **ValueSet**

## ValueSet: ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://www.health.gov.au/assessments/mbs/715/PatientDetails#administrative-gender | *Version*:0.3.0-draft |
| Draft as of 2019-11-01 | *Computable Name*:AdministrativeGender |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.3.1 | |
| **Copyright/Legal**: Copyright © 2011+ HL7. Licensed under Creative Commons "No Rights Reserved". | |

 
The gender of a person used for administrative purposes. 

 **References** 

* [FamilyMemberHistory](http://hl7.org/fhir/R4/familymemberhistory.html)
* [ObservationDefinition](http://hl7.org/fhir/R4/observationdefinition.html)
* [Patient](http://hl7.org/fhir/R4/patient.html)
* [Person](http://hl7.org/fhir/R4/person.html)
* [Practitioner](http://hl7.org/fhir/R4/practitioner.html)
* [RelatedPerson](http://hl7.org/fhir/R4/relatedperson.html)
* [Person Recorded Sex Or Gender](http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-individual-recordedSexOrGender.html)
* [Person Recorded Sex Or Gender](http://hl7.org/fhir/extensions/5.1.0/StructureDefinition-individual-recordedSexOrGender.html)
* [Person Recorded Sex Or Gender](http://hl7.org/fhir/extensions/1.0.0/StructureDefinition-individual-recordedSexOrGender.html)
* [Patient Gender](http://hl7.org/fhir/uv/sdc/2025Jan/StructureDefinition-ProfileExample.html)
* [SDC Question Library](http://hl7.org/fhir/uv/sdc/2025Jan/StructureDefinition-SdcQuestionLibrary.html)
* [SDCAdvancedRenderingExample](http://hl7.org/fhir/uv/sdc/2025Jan/Questionnaire-questionnaire-sdc-profile-example-form-behavior.html)
* [Complex Extract Demonstration - Definition](http://hl7.org/fhir/uv/sdc/2025Jan/Questionnaire-extract-complex-defn3.html)
* [Complex Extract Demonstration - StructureMap](http://hl7.org/fhir/uv/sdc/2025Jan/Questionnaire-extract-complex-smap.html)
* [Complex Extract Demonstration - Template](http://hl7.org/fhir/uv/sdc/2025Jan/Questionnaire-extract-complex-template.html)
* [Complex Extract Demonstration - Template Bundle](http://hl7.org/fhir/uv/sdc/2025Jan/Questionnaire-extract-complex-template2.html)

### Logical Definition (CLD)

Profile: [Shareable ValueSet](http://hl7.org/fhir/R4/shareablevalueset.html)

* Include all codes defined in [`http://hl7.org/fhir/administrative-gender`](http://hl7.org/fhir/R4/codesystem-administrative-gender.html)version 📦4.0.1

 

### Expansion

Expansion based on [codesystem AdministrativeGender v4.0.1 (CodeSystem)](http://hl7.org/fhir/R4/codesystem-administrative-gender.html)

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

