# Questionnaire Repopulation Behavior - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Questionnaire Repopulation Behavior**

## ValueSet: Questionnaire Repopulation Behavior 

| | |
| :--- | :--- |
| *Official URL*:https://smartforms.csiro.au/ig/ValueSet/QuestionnaireRepopulationBehavior | *Version*:0.3.0-draft |
| Draft as of 2025-10-30 | *Computable Name*:QuestionnaireRepopulationBehavior |
| **Copyright/Legal**: Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved. This content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License. See https://creativecommons.org/licenses/by-sa/4.0/. | |

 
The Questionnaire Repopulation Behavior value set includes values that can indicate how a Questionnaire item's initial expression can be re-evaluated and the item repopulated. 

 **References** 

* [Questionnaire Initial Expression Repopulatable](StructureDefinition-questionnaire-initialExpression-repopulatable.md)

### Logical Definition (CLD)

* Include all codes defined in [`https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireRepopulationBehaviorCodes`](CodeSystem-QuestionnaireRepopulationBehaviorCodes.md)version 📦0.3.0-draft

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "QuestionnaireRepopulationBehavior",
  "url" : "https://smartforms.csiro.au/ig/ValueSet/QuestionnaireRepopulationBehavior",
  "version" : "0.3.0-draft",
  "name" : "QuestionnaireRepopulationBehavior",
  "title" : "Questionnaire Repopulation Behavior",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-30T20:31:27+10:00",
  "publisher" : "AEHRC CSIRO",
  "contact" : [
    {
      "name" : "AEHRC CSIRO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.csiro.au/display/PCDQFPhase2/Primary+Care+Data+Quality+Foundations+-+Phase+2"
        }
      ]
    }
  ],
  "description" : "The Questionnaire Repopulation Behavior value set includes values that can indicate how a Questionnaire item's initial expression can be re-evaluated and the item repopulated.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2022+ Australian Government Department of Health and Aged Care - All rights reserved.\nThis content is licensed under a Creative Commons Attribution-ShareAlike 4.0 International License.\nSee https://creativecommons.org/licenses/by-sa/4.0/.\n",
  "compose" : {
    "include" : [
      {
        "system" : "https://smartforms.csiro.au/ig/CodeSystem/QuestionnaireRepopulationBehaviorCodes"
      }
    ]
  }
}

```
