# Biological Sex - Smart Health Checks v0.3.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Biological Sex**

## ValueSet: Biological Sex 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://healthterminologies.gov.au/fhir/ValueSet/biological-sex-1 | *Version*:1.1.0 | |
| Active as of 2024-11-30 | *Responsible:*Australian Digital Health Agency | *Computable Name*:BiologicalSex |
| *Other Identifiers:*OID:1.2.36.1.2001.1004.201.10198 | | |
| **Copyright/Legal**: Copyright © 2020 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/.This resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO.The rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material. No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted.All copies of this resource must include this copyright statement and all information contained in this statement. | | |

 
The Biological Sex value set includes values that represent the biological sex of an individual. 

 **References** 

* [AU Core Sex Assigned At Birth](http://hl7.org.au/fhir/core/2.0.0-ballot/StructureDefinition-au-core-rsg-sexassignedab.html)

### Logical Definition (CLD)

 

### Expansion

This value set expansion contains 8 concepts.

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "biological-sex-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablevalueset",
      "https://healthterminologies.gov.au/fhir/StructureDefinition/composed-value-set-4"
    ]
  },
  "url" : "https://healthterminologies.gov.au/fhir/ValueSet/biological-sex-1",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:1.2.36.1.2001.1004.201.10198"
    }
  ],
  "version" : "1.1.0",
  "name" : "BiologicalSex",
  "title" : "Biological Sex",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-11-30",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    }
  ],
  "description" : "The Biological Sex value set includes values that represent the biological sex of an individual.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU",
          "display" : "Australia"
        }
      ]
    }
  ],
  "copyright" : "Copyright © 2020 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. \n\nThis resource includes SNOMED Clinical Terms™ (SNOMED CT®) which is used by permission of the International Health Terminology Standards Development Organisation (IHTSDO). All rights reserved. SNOMED CT®, was originally created by The College of American Pathologists. “SNOMED” and “SNOMED CT” are registered trademarks of the IHTSDO. \n\nThe rights to use and implement or implementation of SNOMED CT content are limited to the extent it is necessary to allow for the end use of this material.  No further rights are granted in respect of the International Release and no further use of any SNOMED CT content by any other party is permitted. \n\nAll copies of this resource must include this copyright statement and all information contained in this statement.",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "constraint",
            "op" : "=",
            "value" : "^ 32570631000036107|Sex reference set|"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
        "concept" : [
          {
            "code" : "asked-unknown"
          },
          {
            "code" : "unknown"
          },
          {
            "code" : "asked-declined"
          },
          {
            "code" : "not-asked"
          }
        ]
      }
    ]
  }
}

```
